local GlobalAddonName, ExRT = ...

local module = ExRT.mod:New("CSpells",ExRT.L.scspells)
module.db.spells = {}

local SpellData = [[
local module = GExRTCSpellsGlobal
module.db.spells["PALADIN"] = {
	[65] = {635,2812,20473,31842,53551,53563,53576,54428,76669,82326,82327,85222,85512,86103,86669,88821,112859,107,196,197,198,199,200,201,202,498,633,642,750,853,1022,1038,1044,4987,6940,7328,9077,9116,10326,13819,19740,19750,20066,20154,20165,20217,20271,20925,23214,24275,25780,25956,26023,31801,31821,31868,31884,32223,34767,34769,35395,53376,54922,54923,54924,54926,54927,54928,54930,54931,54934,54935,54936,54937,54938,54939,54940,54943,56414,56416,56420,57947,57954,57955,57958,57979,62124,63218,63219,63220,63222,63223,63224,63225,69820,69826,73629,73630,82242,85499,85673,85804,86172,87172,89401,93466,96231,105361,105593,105622,105809,110301,110501,114039,114154,114157,114158,114163,114165,115675,115738,115750,115931,115933,115934,119477,119811,122028,123830,125043,130552,136494,146955,146956,146957,146958,146959,},
	[70] = {879,20164,53385,53503,53595,76672,84963,85256,86539,86698,87138,111529,121783,140333,107,196,197,198,199,200,201,202,498,633,642,750,853,1022,1038,1044,4987,6940,7328,9077,9116,10326,13819,19740,19750,20066,20154,20165,20217,20271,20925,23214,24275,25780,25956,26023,31801,31821,31868,31884,32223,34767,34769,35395,53376,54922,54923,54924,54926,54927,54928,54930,54931,54934,54935,54936,54937,54938,54939,54940,54943,56414,56416,56420,57947,57954,57955,57958,57979,62124,63218,63219,63220,63222,63223,63224,63225,69820,69826,73629,73630,82242,85499,85673,85804,86172,87172,89401,93466,96231,105361,105593,105622,105809,110301,110501,114039,114154,114157,114158,114163,114165,115675,115738,115750,115931,115933,115934,119477,119811,122028,123830,125043,130552,136494,146955,146956,146957,146958,146959,},
	[66] = {26573,31850,31935,53592,53595,53600,76671,84839,85043,86102,86659,105424,105805,119072,107,196,197,198,199,200,201,202,498,633,642,750,853,1022,1038,1044,4987,6940,7328,9077,9116,10326,13819,19740,19750,20066,20154,20165,20217,20271,20925,23214,24275,25780,25956,26023,31801,31821,31868,31884,32223,34767,34769,35395,53376,54922,54923,54924,54926,54927,54928,54930,54931,54934,54935,54936,54937,54938,54939,54940,54943,56414,56416,56420,57947,57954,57955,57958,57979,62124,63218,63219,63220,63222,63223,63224,63225,69820,69826,73629,73630,82242,85499,85673,85804,86172,87172,89401,93466,96231,105361,105593,105622,105809,110301,110501,114039,114154,114157,114158,114163,114165,115675,115738,115750,115931,115933,115934,119477,119811,122028,123830,125043,130552,136494,146955,146956,146957,146958,146959,},
}
module.db.spells["HUNTER"] = {
	[255] = {3674,19387,53301,56343,63458,76658,77767,82834,87935,118976,75,136,196,197,200,201,202,227,264,266,674,781,883,982,1130,1180,1462,1494,1499,1513,1515,1543,1978,2641,2643,3044,3045,5011,5116,5118,5384,6197,6991,8737,9077,13159,13165,13809,13813,15590,19263,19386,19503,19506,19560,19573,19577,19801,19878,19879,19880,19882,19883,19884,19885,20736,20895,34477,34600,51753,53271,53299,53351,56641,56829,56833,56844,56845,56847,56849,56850,57866,57870,57902,57903,57904,63068,63069,77769,82654,82726,83242,83243,83244,83245,83495,86538,93321,93322,109212,109215,109248,109259,109260,109263,109298,109304,109306,110497,117050,118424,118675,119384,119403,119407,119410,119447,119449,119462,119464,120360,120679,120697,121818,122492,123632,125042,126095,126179,126193,126746,130392,131894,132106,138430,146657,147362,148473,148475,148484,},
	[254] = {19434,34483,34487,34490,35102,35110,53209,53224,53232,53238,76659,75,136,196,197,200,201,202,227,264,266,674,781,883,982,1130,1180,1462,1494,1499,1513,1515,1543,1978,2641,2643,3044,3045,5011,5116,5118,5384,6197,6991,8737,9077,13159,13165,13809,13813,15590,19263,19386,19503,19506,19560,19573,19577,19801,19878,19879,19880,19882,19883,19884,19885,20736,20895,34477,34600,51753,53271,53299,53351,56641,56829,56833,56844,56845,56847,56849,56850,57866,57870,57902,57903,57904,63068,63069,77769,82654,82726,83242,83243,83244,83245,83495,86538,93321,93322,109212,109215,109248,109259,109260,109263,109298,109304,109306,110497,117050,118424,118675,119384,119403,119407,119410,119447,119449,119462,119464,120360,120679,120697,121818,122492,123632,125042,126095,126179,126193,126746,130392,131894,132106,138430,146657,147362,148473,148475,148484,},
	[253] = {19574,19623,34026,34692,34954,53253,53260,53270,56315,76657,77767,82692,115939,75,136,196,197,200,201,202,227,264,266,674,781,883,982,1130,1180,1462,1494,1499,1513,1515,1543,1978,2641,2643,3044,3045,5011,5116,5118,5384,6197,6991,8737,9077,13159,13165,13809,13813,15590,19263,19386,19503,19506,19560,19573,19577,19801,19878,19879,19880,19882,19883,19884,19885,20736,20895,34477,34600,51753,53271,53299,53351,56641,56829,56833,56844,56845,56847,56849,56850,57866,57870,57902,57903,57904,63068,63069,77769,82654,82726,83242,83243,83244,83245,83495,86538,93321,93322,109212,109215,109248,109259,109260,109263,109298,109304,109306,110497,117050,118424,118675,119384,119403,119407,119410,119447,119449,119462,119464,120360,120679,120697,121818,122492,123632,125042,126095,126179,126193,126746,130392,131894,132106,138430,146657,147362,148473,148475,148484,},
}
module.db.spells["WARRIOR"] = {
	[73] = {1160,2565,6572,12975,20243,23922,29144,46953,76857,84608,84615,86535,93098,112048,122509,145672,71,78,100,107,196,197,198,199,200,201,202,227,264,266,355,469,674,676,750,845,871,1180,1715,1719,2457,2458,3127,3411,5011,5246,5308,6343,6544,6552,6673,7386,9077,9116,12292,12323,13046,15590,18499,23920,29838,34428,46924,46968,55694,57755,58095,58096,58097,58098,58099,58104,58355,58356,58357,58364,58366,58367,58368,58369,58370,58372,58375,58377,58382,58384,58385,58386,58387,58388,63324,63325,63327,63328,63329,64382,68164,88163,89003,94372,94374,97462,102060,103826,103827,103828,103840,107566,107570,107574,110506,112104,114028,114029,114030,114192,114203,114207,115767,115943,115946,118000,119811,122013,122475,123779,123829,146965,146968,146969,146970,146971,146973,146974,},
	[71] = {1464,1680,7384,12294,12328,12712,29725,56636,76838,84615,86101,86346,118038,143268,71,78,100,107,196,197,198,199,200,201,202,227,264,266,355,469,674,676,750,845,871,1180,1715,1719,2457,2458,3127,3411,5011,5246,5308,6343,6544,6552,6673,7386,9077,9116,12292,12323,13046,15590,18499,23920,29838,34428,46924,46968,55694,57755,58095,58096,58097,58098,58099,58104,58355,58356,58357,58364,58366,58367,58368,58369,58370,58372,58375,58377,58382,58384,58385,58386,58387,58388,63324,63325,63327,63328,63329,64382,68164,88163,89003,94372,94374,97462,102060,103826,103827,103828,103840,107566,107570,107574,110506,112104,114028,114029,114030,114192,114203,114207,115767,115943,115946,118000,119811,122013,122475,123779,123829,146965,146968,146969,146970,146971,146973,146974,},
	[72] = {1680,12950,12972,23588,23881,46915,46917,76856,81099,85288,86110,86346,100130,118038,143268,71,78,100,107,196,197,198,199,200,201,202,227,264,266,355,469,674,676,750,845,871,1180,1715,1719,2457,2458,3127,3411,5011,5246,5308,6343,6544,6552,6673,7386,9077,9116,12292,12323,13046,15590,18499,23920,29838,34428,46924,46968,55694,57755,58095,58096,58097,58098,58099,58104,58355,58356,58357,58364,58366,58367,58368,58369,58370,58372,58375,58377,58382,58384,58385,58386,58387,58388,63324,63325,63327,63328,63329,64382,68164,88163,89003,94372,94374,97462,102060,103826,103827,103828,103840,107566,107570,107574,110506,112104,114028,114029,114030,114192,114203,114207,115767,115943,115946,118000,119811,122013,122475,123779,123829,146965,146968,146969,146970,146971,146973,146974,},
}
module.db.spells["DRUID"] = {
	[103] = {1079,2782,5217,5221,6785,16864,16974,17007,33873,48484,52610,61336,77493,86097,106832,106839,106952,99,198,199,200,227,339,740,768,770,774,779,783,1066,1126,1180,1822,1850,2637,2908,5176,5185,5211,5215,5225,5487,6795,6807,8921,9005,9077,15590,16689,16870,16914,16961,17076,18960,20484,22568,22570,22812,22842,29166,33745,33786,33876,33878,33917,33943,40120,47180,48514,50769,54733,54760,54810,54811,54812,54821,54825,54831,54832,57855,57856,59219,62078,62080,62970,63057,67598,77758,94386,102280,102351,102359,102401,102545,102793,106707,106731,106737,106785,106830,106898,106922,106996,107059,108238,108288,108373,110309,114107,114222,114223,114234,114237,114280,114295,114300,114301,114333,114338,116172,116186,116203,116216,116218,116238,121840,124974,125047,125972,127540,131113,131768,132469,145108,145529,146654,146655,146656,},
	[104] = {1079,2782,5229,6785,16931,17007,33873,48484,61336,62606,77494,84840,86096,102795,106832,106839,106952,135288,99,198,199,200,227,339,740,768,770,774,779,783,1066,1126,1180,1822,1850,2637,2908,5176,5185,5211,5215,5225,5487,6795,6807,8921,9005,9077,15590,16689,16870,16914,16961,17076,18960,20484,22568,22570,22812,22842,29166,33745,33786,33876,33878,33917,33943,40120,47180,48514,50769,54733,54760,54810,54811,54812,54821,54825,54831,54832,57855,57856,59219,62078,62080,62970,63057,67598,77758,94386,102280,102351,102359,102401,102545,102793,106707,106731,106737,106785,106830,106898,106922,106996,107059,108238,108288,108373,110309,114107,114222,114223,114234,114237,114280,114295,114300,114301,114333,114338,116172,116186,116203,116216,116218,116238,121840,124974,125047,125972,127540,131113,131768,132469,145108,145529,146654,146655,146656,},
	[102] = {2782,2912,24858,33596,33605,48393,48505,77492,78674,78675,81062,86104,88747,88751,93399,93402,108299,112071,112857,127663,132158,99,198,199,200,227,339,740,768,770,774,779,783,1066,1126,1180,1822,1850,2637,2908,5176,5185,5211,5215,5225,5487,6795,6807,8921,9005,9077,15590,16689,16870,16914,16961,17076,18960,20484,22568,22570,22812,22842,29166,33745,33786,33876,33878,33917,33943,40120,47180,48514,50769,54733,54760,54810,54811,54812,54821,54825,54831,54832,57855,57856,59219,62078,62080,62970,63057,67598,77758,94386,102280,102351,102359,102401,102545,102793,106707,106731,106737,106785,106830,106898,106922,106996,107059,108238,108288,108373,110309,114107,114222,114223,114234,114237,114280,114295,114300,114301,114333,114338,116172,116186,116203,116216,116218,116238,121840,124974,125047,125972,127540,131113,131768,132469,145108,145529,146654,146655,146656,},
	[105] = {8936,17073,18562,33763,33886,48438,48500,50464,77495,84736,85101,86093,88423,92364,102342,102791,108299,112857,113043,132158,145205,145518,99,198,199,200,227,339,740,768,770,774,779,783,1066,1126,1180,1822,1850,2637,2908,5176,5185,5211,5215,5225,5487,6795,6807,8921,9005,9077,15590,16689,16870,16914,16961,17076,18960,20484,22568,22570,22812,22842,29166,33745,33786,33876,33878,33917,33943,40120,47180,48514,50769,54733,54760,54810,54811,54812,54821,54825,54831,54832,57855,57856,59219,62078,62080,62970,63057,67598,77758,94386,102280,102351,102359,102401,102545,102793,106707,106731,106737,106785,106830,106898,106922,106996,107059,108238,108288,108373,110309,114107,114222,114223,114234,114237,114280,114295,114300,114301,114333,114338,116172,116186,116203,116216,116218,116238,121840,124974,125047,125972,127540,131113,131768,132469,145108,145529,146654,146655,146656,},
}
module.db.spells["PRIEST"] = {
	[256] = {527,596,2050,2060,14914,33206,45243,47515,47517,47536,47540,52798,62618,77484,81662,81700,81749,87336,89485,89488,92297,95860,108968,109964,17,139,198,227,528,585,586,588,589,605,1180,1706,2006,2061,2096,5009,5019,6346,8122,9484,10060,14771,19236,21562,32375,32379,32546,33076,33202,33371,34433,48045,55672,55673,55675,55676,55677,55678,55684,55685,55686,55688,55690,55691,55692,57985,57986,58009,58228,63229,63248,64129,64901,73325,73413,84733,87195,89489,89745,107906,108920,108921,108939,108942,108945,109142,109175,109186,110502,110744,112833,119850,119853,119864,119866,119872,119873,120517,120581,120583,120584,120585,121135,121536,123040,125045,126094,126133,126152,126174,126745,139139,145722,147072,147776,147778,147779,},
	[257] = {527,596,2050,2060,14914,20711,34861,45243,47788,63733,64843,77485,81206,81208,81209,81662,87336,88625,95649,95861,108968,126135,17,139,198,227,528,585,586,588,589,605,1180,1706,2006,2061,2096,5009,5019,6346,8122,9484,10060,14771,19236,21562,32375,32379,32546,33076,33202,33371,34433,48045,55672,55673,55675,55676,55677,55678,55684,55685,55686,55688,55690,55691,55692,57985,57986,58009,58228,63229,63248,64129,64901,73325,73413,84733,87195,89489,89745,107906,108920,108921,108939,108942,108945,109142,109175,109186,110502,110744,112833,119850,119853,119864,119866,119872,119873,120517,120581,120583,120584,120585,121135,121536,123040,125045,126094,126133,126152,126174,126745,139139,145722,147072,147776,147778,147779,},
	[258] = {2944,8092,15286,15407,15473,15487,34914,47573,47585,64044,73510,77486,78203,95740,142723,17,139,198,227,528,585,586,588,589,605,1180,1706,2006,2061,2096,5009,5019,6346,8122,9484,10060,14771,19236,21562,32375,32379,32546,33076,33202,33371,34433,48045,55672,55673,55675,55676,55677,55678,55684,55685,55686,55688,55690,55691,55692,57985,57986,58009,58228,63229,63248,64129,64901,73325,73413,84733,87195,89489,89745,107906,108920,108921,108939,108942,108945,109142,109175,109186,110502,110744,112833,119850,119853,119864,119866,119872,119873,120517,120581,120583,120584,120585,121135,121536,123040,125045,126094,126133,126152,126174,126745,139139,145722,147072,147776,147778,147779,},
}
module.db.spells["MAGE"] = {
	[64] = {116,12472,31687,44549,76613,84714,112965,10,66,118,120,122,130,201,227,475,759,1180,1449,1459,1463,1953,2120,2136,2139,3561,3562,3563,3565,3566,3567,5009,5019,6117,7302,10059,11416,11417,11418,11419,11420,11426,11958,12043,12051,12598,12982,28271,28272,30449,30455,30482,32266,32267,32271,32272,33690,33691,35715,35717,42955,43987,44457,44572,44614,45438,49358,49359,49360,49361,52648,53140,53142,55342,56363,56364,56365,56368,56375,56376,56377,56380,56382,56383,56384,57924,57925,57927,58136,61205,61305,61316,61721,61780,62210,63090,63092,63093,80353,84254,86209,86949,88342,88344,88345,88346,89744,89749,89926,98397,102051,108839,108843,108978,110499,110959,111264,112948,113724,114003,114923,115610,115700,115703,115705,115710,115713,115718,115723,116011,117957,120145,120146,125430,126201,126748,132620,132621,132626,132627,134580,140468,146659,146662,146976,147353,},
	[63] = {133,2948,11129,11366,12846,31661,108853,117216,132209,10,66,118,120,122,130,201,227,475,759,1180,1449,1459,1463,1953,2120,2136,2139,3561,3562,3563,3565,3566,3567,5009,5019,6117,7302,10059,11416,11417,11418,11419,11420,11426,11958,12043,12051,12598,12982,28271,28272,30449,30455,30482,32266,32267,32271,32272,33690,33691,35715,35717,42955,43987,44457,44572,44614,45438,49358,49359,49360,49361,52648,53140,53142,55342,56363,56364,56365,56368,56375,56376,56377,56380,56382,56383,56384,57924,57925,57927,58136,61205,61305,61316,61721,61780,62210,63090,63092,63093,80353,84254,86209,86949,88342,88344,88345,88346,89744,89749,89926,98397,102051,108839,108843,108978,110499,110959,111264,112948,113724,114003,114923,115610,115700,115703,115705,115710,115713,115718,115723,116011,117957,120145,120146,125430,126201,126748,132620,132621,132626,132627,134580,140468,146659,146662,146976,147353,},
	[62] = {5143,12042,30451,31589,44425,76547,114664,10,66,118,120,122,130,201,227,475,759,1180,1449,1459,1463,1953,2120,2136,2139,3561,3562,3563,3565,3566,3567,5009,5019,6117,7302,10059,11416,11417,11418,11419,11420,11426,11958,12043,12051,12598,12982,28271,28272,30449,30455,30482,32266,32267,32271,32272,33690,33691,35715,35717,42955,43987,44457,44572,44614,45438,49358,49359,49360,49361,52648,53140,53142,55342,56363,56364,56365,56368,56375,56376,56377,56380,56382,56383,56384,57924,57925,57927,58136,61205,61305,61316,61721,61780,62210,63090,63092,63093,80353,84254,86209,86949,88342,88344,88345,88346,89744,89749,89926,98397,102051,108839,108843,108978,110499,110959,111264,112948,113724,114003,114923,115610,115700,115703,115705,115710,115713,115718,115723,116011,117957,120145,120146,125430,126201,126748,132620,132621,132626,132627,134580,140468,146659,146662,146976,147353,},
}
module.db.spells["MONK"] = {
	[269] = {101545,107428,113656,115073,115288,115636,116023,116092,116740,116781,120227,120272,122470,123980,124146,126046,128595,137384,137639,196,198,200,201,227,674,9077,15590,100780,100784,100787,101546,101643,103985,109132,110500,115008,115072,115074,115078,115080,115098,115173,115174,115176,115178,115203,115396,115399,115450,115460,115546,115921,116095,116705,116812,116841,116844,116847,117368,117952,119381,119392,119996,120277,120477,120479,120482,120483,121817,122278,122280,122783,123023,123334,123391,123394,123399,123401,123403,123405,123763,123904,123986,124081,124334,124989,124997,125151,125154,125660,125671,125673,125676,125678,125732,125755,125872,125893,125901,125931,125967,126892,126895,132005,137562,146950,146951,146952,146953,146954,},
	[268] = {115069,115180,115181,115213,115295,115308,115315,117906,117967,119582,120225,120267,121253,122057,124146,124502,126060,128938,196,198,200,201,227,674,9077,15590,100780,100784,100787,101546,101643,103985,109132,110500,115008,115072,115074,115078,115080,115098,115173,115174,115176,115178,115203,115396,115399,115450,115460,115546,115921,116095,116705,116812,116841,116844,116847,117368,117952,119381,119392,119996,120277,120477,120479,120482,120483,121817,122278,122280,122783,123023,123334,123391,123394,123399,123401,123403,123405,123763,123904,123986,124081,124334,124989,124997,125151,125154,125660,125671,125673,125676,125678,125732,125755,125872,125893,125901,125931,125967,126892,126895,132005,137562,146950,146951,146952,146953,146954,},
	[270] = {115070,115151,115175,115294,115310,115313,115451,116645,116670,116680,116694,116849,117907,120224,120272,121278,122464,123766,124682,139598,196,198,200,201,227,674,9077,15590,100780,100784,100787,101546,101643,103985,109132,110500,115008,115072,115074,115078,115080,115098,115173,115174,115176,115178,115203,115396,115399,115450,115460,115546,115921,116095,116705,116812,116841,116844,116847,117368,117952,119381,119392,119996,120277,120477,120479,120482,120483,121817,122278,122280,122783,123023,123334,123391,123394,123399,123401,123403,123405,123763,123904,123986,124081,124334,124989,124997,125151,125154,125660,125671,125673,125676,125678,125732,125755,125872,125893,125901,125931,125967,126892,126895,132005,137562,146950,146951,146952,146953,146954,},
}
module.db.spells["ROGUE"] = {
	[261] = {53,14183,16511,31220,31223,51701,51713,76808,79147,79152,91023,196,198,201,264,266,408,674,703,921,1180,1725,1752,1766,1776,1784,1804,1833,1842,1856,1860,1943,1966,2094,2098,2823,2836,2983,3408,5011,5171,5277,5761,5938,6770,8647,8676,8679,9077,14062,14185,15590,26679,31209,31224,31230,36554,51722,51723,56799,56800,56801,56803,56804,56805,56806,56807,56808,56809,56810,56811,56812,56813,56818,56819,57934,58017,58027,58032,58033,58038,58039,58410,58423,63249,63252,63253,63254,63256,63268,63269,73651,73981,74001,76577,79008,82245,86092,89758,91299,108208,108209,108210,108211,108212,108215,108216,110503,113742,114014,114015,114018,114842,121411,121471,121733,125044,131511,137619,138106,146625,146628,146629,146631,146960,146961,},
	[259] = {1329,14117,14190,32645,51667,76803,79134,79140,84601,111240,121152,196,198,201,264,266,408,674,703,921,1180,1725,1752,1766,1776,1784,1804,1833,1842,1856,1860,1943,1966,2094,2098,2823,2836,2983,3408,5011,5171,5277,5761,5938,6770,8647,8676,8679,9077,14062,14185,15590,26679,31209,31224,31230,36554,51722,51723,56799,56800,56801,56803,56804,56805,56806,56807,56808,56809,56810,56811,56812,56813,56818,56819,57934,58017,58027,58032,58033,58038,58039,58410,58423,63249,63252,63253,63254,63256,63268,63269,73651,73981,74001,76577,79008,82245,86092,89758,91299,108208,108209,108210,108211,108212,108215,108216,110503,113742,114014,114015,114018,114842,121411,121471,121733,125044,131511,137619,138106,146625,146628,146629,146631,146960,146961,},
	[260] = {13750,13852,13877,14161,35551,51690,61329,76806,79096,84617,84654,196,198,201,264,266,408,674,703,921,1180,1725,1752,1766,1776,1784,1804,1833,1842,1856,1860,1943,1966,2094,2098,2823,2836,2983,3408,5011,5171,5277,5761,5938,6770,8647,8676,8679,9077,14062,14185,15590,26679,31209,31224,31230,36554,51722,51723,56799,56800,56801,56803,56804,56805,56806,56807,56808,56809,56810,56811,56812,56813,56818,56819,57934,58017,58027,58032,58033,58038,58039,58410,58423,63249,63252,63253,63254,63256,63268,63269,73651,73981,74001,76577,79008,82245,86092,89758,91299,108208,108209,108210,108211,108212,108215,108216,110503,113742,114014,114015,114018,114842,121411,121471,121733,125044,131511,137619,138106,146625,146628,146629,146631,146960,146961,},
}
module.db.spells["DEATHKNIGHT"] = {
	[250] = {48982,49028,49222,49509,49542,50029,50034,50371,55050,55233,56222,56815,77513,81127,81132,81136,81164,86537,93099,114866,145676,148211,196,197,198,199,200,201,202,674,750,3714,9077,42650,43265,45462,45477,45524,45529,45902,46584,47476,47528,47541,47568,48263,48265,48266,48707,48721,48743,48792,49039,49576,49998,50041,50842,50977,51052,51462,51986,53323,53331,53341,53342,53343,53344,53428,54446,54447,54729,55078,55095,57330,58616,58618,58620,58623,58629,58631,58635,58640,58642,58647,58657,58669,58671,58673,58676,58677,58680,58686,59307,59309,59327,59332,59336,59879,59921,60200,61999,62158,62259,63330,63331,63333,63335,70164,73975,77575,77606,81229,82246,86524,96268,96279,108170,108194,108196,108199,108200,108201,110498,111673,114556,115989,119811,119975,123693,146645,146646,146648,146650,146652,146653,},
	[252] = {49016,49206,49530,49572,50392,51160,52143,55090,55610,56835,63560,77515,85948,86536,91107,130736,196,197,198,199,200,201,202,674,750,3714,9077,42650,43265,45462,45477,45524,45529,45902,46584,47476,47528,47541,47568,48263,48265,48266,48707,48721,48743,48792,49039,49576,49998,50041,50842,50977,51052,51462,51986,53323,53331,53341,53342,53343,53344,53428,54446,54447,54729,55078,55095,57330,58616,58618,58620,58623,58629,58631,58635,58640,58642,58647,58657,58669,58671,58673,58676,58677,58680,58686,59307,59309,59327,59332,59336,59879,59921,60200,61999,62158,62259,63330,63331,63333,63335,70164,73975,77575,77606,81229,82246,86524,96268,96279,108170,108194,108196,108199,108200,108201,110498,111673,114556,115989,119811,119975,123693,146645,146646,146648,146650,146652,146653,},
	[251] = {49020,49143,49184,50385,50887,51128,51271,54637,55610,59057,66192,77514,81328,81333,86113,130735,196,197,198,199,200,201,202,674,750,3714,9077,42650,43265,45462,45477,45524,45529,45902,46584,47476,47528,47541,47568,48263,48265,48266,48707,48721,48743,48792,49039,49576,49998,50041,50842,50977,51052,51462,51986,53323,53331,53341,53342,53343,53344,53428,54446,54447,54729,55078,55095,57330,58616,58618,58620,58623,58629,58631,58635,58640,58642,58647,58657,58669,58671,58673,58676,58677,58680,58686,59307,59309,59327,59332,59336,59879,59921,60200,61999,62158,62259,63330,63331,63333,63335,70164,73975,77575,77606,81229,82246,86524,96268,96279,108170,108194,108196,108199,108200,108201,110498,111673,114556,115989,119811,119975,123693,146645,146646,146648,146650,146652,146653,},
}
module.db.spells["WARLOCK"] = {
	[267] = {348,5740,17877,17962,29722,77220,80240,108563,108647,108683,109784,111546,113858,114635,116858,117896,120451,123686,126,172,201,227,686,688,689,691,697,698,710,712,755,1098,1122,1180,1454,1490,5009,5019,5484,5697,5782,5784,6201,6229,6789,18540,20707,23161,29858,29893,30283,47897,48018,48020,56217,56218,56224,56226,56231,56232,56233,56235,56238,56240,56241,56242,56244,56246,56247,56248,56249,56250,58070,58079,58080,58081,58094,58107,63106,63302,63303,63304,63309,63312,63320,77799,86091,93375,101976,103128,103130,103133,103135,103136,103139,103140,103141,103142,103150,104773,104938,108359,108370,108371,108415,108416,108482,108499,108501,108503,108505,108508,109466,109773,110505,110913,111397,111400,111771,119898,124538,124539,131973,135032,135557,137587,146962,146963,146964,148683,},
	[265] = {980,1120,5740,18223,27243,30108,48181,53759,74434,77215,86121,86664,103101,103103,103112,104243,108558,113860,117198,141931,126,172,201,227,686,688,689,691,697,698,710,712,755,1098,1122,1180,1454,1490,5009,5019,5484,5697,5782,5784,6201,6229,6789,18540,20707,23161,29858,29893,30283,47897,48018,48020,56217,56218,56224,56226,56231,56232,56233,56235,56238,56240,56241,56242,56244,56246,56247,56248,56249,56250,58070,58079,58080,58081,58094,58107,63106,63302,63303,63304,63309,63312,63320,77799,86091,93375,101976,103128,103130,103133,103135,103136,103139,103140,103141,103142,103150,104773,104938,108359,108370,108371,108415,108416,108482,108499,108501,108503,108505,108508,109466,109773,110505,110913,111397,111400,111771,119898,124538,124539,131973,135032,135557,137587,146962,146963,146964,148683,},
	[266] = {1949,6353,30146,77219,103129,103131,103134,103958,103967,104315,105174,108559,108869,109151,109797,112089,113861,114129,114592,116208,122351,124913,124917,129343,126,172,201,227,686,688,689,691,697,698,710,712,755,1098,1122,1180,1454,1490,5009,5019,5484,5697,5782,5784,6201,6229,6789,18540,20707,23161,29858,29893,30283,47897,48018,48020,56217,56218,56224,56226,56231,56232,56233,56235,56238,56240,56241,56242,56244,56246,56247,56248,56249,56250,58070,58079,58080,58081,58094,58107,63106,63302,63303,63304,63309,63312,63320,77799,86091,93375,101976,103128,103130,103133,103135,103136,103139,103140,103141,103142,103150,104773,104938,108359,108370,108371,108415,108416,108482,108499,108501,108503,108505,108508,109466,109773,110505,110913,111397,111400,111771,119898,124538,124539,131973,135032,135557,137587,146962,146963,146964,148683,},
}
module.db.spells["SHAMAN"] = {
	[264] = {331,974,16190,16196,16213,51505,51558,51564,51730,61295,77130,77226,77472,86100,95862,98008,112858,107,196,197,198,199,227,324,370,403,421,546,556,1064,1180,2008,2062,2484,2645,2825,2894,3599,5394,6196,8004,8017,8024,8033,8042,8050,8056,8143,8177,8190,8737,9077,9116,15590,16166,16188,20608,30884,32182,36936,51485,51514,51886,52127,55436,55437,55438,55439,55440,55441,55442,55443,55444,55445,55446,55447,55448,55449,55450,55451,55452,55453,55454,55455,55456,57994,58057,58058,58059,58135,59289,62132,63270,63271,63273,63279,63280,63291,63298,63374,73680,73899,73920,76780,77747,79206,86529,89646,101052,108269,108270,108271,108273,108280,108281,108282,108283,108284,108285,108287,110504,114049,116956,117012,117013,117014,120668,147074,147707,147762,147770,147772,147781,147783,147784,147785,147787,147788,},
	[263] = {1535,8232,16282,17364,30809,30814,30823,51522,51527,51530,51533,58875,60103,77223,77657,86099,86629,107,196,197,198,199,227,324,370,403,421,546,556,1064,1180,2008,2062,2484,2645,2825,2894,3599,5394,6196,8004,8017,8024,8033,8042,8050,8056,8143,8177,8190,8737,9077,9116,15590,16166,16188,20608,30884,32182,36936,51485,51514,51886,52127,55436,55437,55438,55439,55440,55441,55442,55443,55444,55445,55446,55447,55448,55449,55450,55451,55452,55453,55454,55455,55456,57994,58057,58058,58059,58135,59289,62132,63270,63271,63273,63279,63280,63291,63298,63374,73680,73899,73920,76780,77747,79206,86529,89646,101052,108269,108270,108271,108273,108280,108281,108282,108283,108284,108285,108287,110504,114049,116956,117012,117013,117014,120668,147074,147707,147762,147770,147772,147781,147783,147784,147785,147787,147788,},
	[262] = {16164,29000,30674,30823,51470,51490,51505,60188,61882,62099,77222,77756,86108,88764,88766,123099,107,196,197,198,199,227,324,370,403,421,546,556,1064,1180,2008,2062,2484,2645,2825,2894,3599,5394,6196,8004,8017,8024,8033,8042,8050,8056,8143,8177,8190,8737,9077,9116,15590,16166,16188,20608,30884,32182,36936,51485,51514,51886,52127,55436,55437,55438,55439,55440,55441,55442,55443,55444,55445,55446,55447,55448,55449,55450,55451,55452,55453,55454,55455,55456,57994,58057,58058,58059,58135,59289,62132,63270,63271,63273,63279,63280,63291,63298,63374,73680,73899,73920,76780,77747,79206,86529,89646,101052,108269,108270,108271,108273,108280,108281,108282,108283,108284,108285,108287,110504,114049,116956,117012,117013,117014,120668,147074,147707,147762,147770,147772,147781,147783,147784,147785,147787,147788,},
}
module.db.spells["PET"] = {
	[0] = {1742,2649,3110,3716,4167,6358,6360,7814,7870,16827,17253,17735,17767,19505,19647,24423,24450,24604,24844,25027,26064,26090,30151,30153,30213,31707,32233,33395,34889,35290,35346,36213,47468,47481,47482,47484,49966,50245,50256,50274,50285,50318,50433,50479,50498,50518,50519,50541,54049,54644,54680,54706,55749,56626,57386,57984,58604,62137,65220,88680,89751,89766,89792,89808,90309,90314,90327,90328,90337,90339,90347,90355,90361,90363,90364,91644,91776,91778,91797,91800,91802,91809,91837,91838,92380,93433,93434,93435,94019,94022,96201,97229,112042,114355,115232,115236,115268,115276,115284,115408,115578,115625,115746,115748,115770,115778,115781,115831,117225,117588,118093,118297,118337,118345,118347,118350,119899,123746,126246,126259,126309,126311,126355,126364,126373,126393,126402,126423,128432,128433,128997,134477,135678,137798,},
}
]]

module.db.classNames = {"WARRIOR","PALADIN","HUNTER","ROGUE","PRIEST","DEATHKNIGHT","SHAMAN","MAGE","WARLOCK","MONK","DRUID","PET"}

module.db.specByClass = {
	["HUNTER"] = {253,254,255,},
	["WARRIOR"] = {71,72,73,},
	["PALADIN"] = {65,66,70,},
	["MAGE"] = {62,63,64,},
	["PRIEST"] = {256,257,258,},
	["MONK"] = {268,269,270,},
	["WARLOCK"] = {265,266,267,},
	["SHAMAN"] = {262,263,264,},
	["ROGUE"] = {259,260,261,},
	["DRUID"] = {102,103,104,105,},
	["DEATHKNIGHT"] = {250,251,252,},
}

module.db.specInLocalizate = {
	[62] = "MAGEDPS1",
	[63] = "MAGEDPS2",
	[64] = "MAGEDPS3",
	[65] = "PALADINHEAL",
	[66] = "PALADINTANK",
	[70] = "PALADINDPS",
	[71] = "WARRIORDPS1",
	[72] = "WARRIORDPS2",
	[73] = "WARRIORTANK",
	[102] = "DRUIDDPS1",
	[103] = "DRUIDDPS2",
	[104] = "DRUIDTANK",
	[105] = "DRUIDHEAL",
	[250] = "DEATHKNIGHTTANK",
	[251] = "DEATHKNIGHTDPS1",
	[252] = "DEATHKNIGHTDPS2",
	[253] = "HUNTERDPS1",
	[254] = "HUNTERDPS2",
	[255] = "HUNTERDPS3",
	[256] = "PRIESTHEAL1",
	[257] = "PRIESTHEAL2",
	[258] = "PRIESTDPS",
	[259] = "ROGUEDPS1",
	[260] = "ROGUEDPS2",
	[261] = "ROGUEDPS3",
	[262] = "SHAMANDPS1",
	[263] = "SHAMANDPS2",
	[264] = "SHAMANHEAL",
	[265] = "WARLOCKDPS1",
	[266] = "WARLOCKDPS2",
	[267] = "WARLOCKDPS3",
	[268] = "MONKTANK",
	[269] = "MONKDPS",
	[270] = "MONKHEAL",
	[0] = "NO",
}
module.db.specIcons = {
	[62] = "Interface\\Icons\\Spell_Holy_MagicalSentry",
	[63] = "Interface\\Icons\\Spell_Fire_FireBolt02",
	[64] = "Interface\\Icons\\Spell_Frost_FrostBolt02",
	[65] = "Interface\\Icons\\Spell_Holy_HolyBolt",
	[66] = "Interface\\Icons\\Ability_Paladin_ShieldoftheTemplar",
	[70] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[71] = "Interface\\Icons\\Ability_Warrior_SavageBlow",
	[72] = "Interface\\Icons\\Ability_Warrior_InnerRage",
	[73] = "Interface\\Icons\\Ability_Warrior_DefensiveStance",
	[102] = "Interface\\Icons\\Spell_Nature_StarFall",
	[103] = "Interface\\Icons\\Ability_Druid_CatForm",
	[104] = "Interface\\Icons\\Ability_Racial_BearForm",
	[105] = "Interface\\Icons\\Spell_Nature_HealingTouch",
	[250] = "Interface\\Icons\\Spell_Deathknight_BloodPresence",
	[251] = "Interface\\Icons\\Spell_Deathknight_FrostPresence",
	[252] = "Interface\\Icons\\Spell_Deathknight_UnholyPresence",
	[253] = "INTERFACE\\ICONS\\ability_hunter_bestialdiscipline",
	[254] = "Interface\\Icons\\Ability_Hunter_FocusedAim",
	[255] = "INTERFACE\\ICONS\\ability_hunter_camouflage",
	[256] = "Interface\\Icons\\Spell_Holy_PowerWordShield",
	[257] = "Interface\\Icons\\Spell_Holy_GuardianSpirit",
	[258] = "Interface\\Icons\\Spell_Shadow_ShadowWordPain",
	[259] = "Interface\\Icons\\Ability_Rogue_Eviscerate",
	[260] = "Interface\\Icons\\Ability_BackStab",
	[261] = "Interface\\Icons\\Ability_Stealth",
	[262] = "Interface\\Icons\\Spell_Nature_Lightning",
	[263] = "Interface\\Icons\\Spell_Shaman_ImprovedStormstrike",
	[264] = "Interface\\Icons\\Spell_Nature_MagicImmunity",
	[265] = "Interface\\Icons\\Spell_Shadow_DeathCoil",
	[266] = "Interface\\Icons\\Spell_Shadow_Metamorphosis",
	[267] = "Interface\\Icons\\Spell_Shadow_RainOfFire",
	[268] = "Interface\\Icons\\spell_monk_brewmaster_spec",
	[269] = "Interface\\Icons\\spell_monk_windwalker_spec",
	[270] = "Interface\\Icons\\spell_monk_mistweaver_spec",
}

function module.options:Load()
	loadstring(SpellData)()
	SpellData = nil
	
	local ReloadPage = nil
	local classNow = "PALADIN"
	local specNow = 1
	local scrollFrameValue = 0
	local scrollFix = false
		
	self.scrollFrame = ExRT.lib.CreateScrollFrame(self:GetName().."ScrollFrame",self,600,520,"CENTER",0,-15,1070)
	
	local spellLineHeight = 26
	local spellLineWidth = 194
	self.scrollFrame.C.spells = {}
	local function SpellLineClick(self)
		ExRT.mds.LinkSpell(self.spellID)
	end
	local function SpellLineEnter(self)
		ExRT.lib.OnEnterHyperLinkTooltip(self,self.link) 
	end
	local function SpellLineLeave(self)
		ExRT.lib.OnLeaveHyperLinkTooltip() 
	end
	for i=1,3 do
		for j=1,22 do
			local frame = CreateFrame("Button",nil,self.scrollFrame.C)
			self.scrollFrame.C.spells[(j-1)*3+i] = frame
			frame:SetSize(spellLineWidth,spellLineHeight)
			frame:SetPoint("TOPLEFT", (i-1)*spellLineWidth, -(j-1)*spellLineHeight)
			frame.icon = frame:CreateTexture(nil, "BACKGROUND")
			frame.icon:SetTexture("Interface\\Icons\\INV_MISC_QUESTIONMARK")
			frame.icon:SetPoint("TOPLEFT", 0, 0)
			frame.icon:SetSize(spellLineHeight-1,spellLineHeight-1)
		
			frame.spellID = 0
	
			frame:RegisterForClicks("LeftButtonDown")
			frame:SetScript("OnClick", SpellLineClick)
	
			frame.spellName = ExRT.lib.CreateText(frame,spellLineWidth-spellLineHeight-5,spellLineHeight,nil,spellLineHeight+5, 0,nil,nil,nil,10,(j-1)*3+i,nil,1,1,1)
		
			frame:SetScript("OnEnter", SpellLineEnter)
			frame:SetScript("OnLeave", SpellLineLeave)
		end
	end
	self.scrollFrame.ScrollBar:SetScript("OnValueChanged", function(self,value)
		if scrollFix then
			return
		end
		local parent = self:GetParent()
		value = ExRT.mds.Round(value)
		parent:SetVerticalScroll(value % spellLineHeight) 
		self:reButtonsState()
		local nowVal = floor(value / spellLineHeight)
		if nowVal ~= scrollFrameValue then
			scrollFrameValue = nowVal
			ReloadPage()
		end
	end)
	function ReloadPage()
		local start = scrollFrameValue * 3
		local specID = module.db.specByClass[classNow] and module.db.specByClass[classNow][specNow] or 0
		for i=1,66 do
			local spellID = module.db.spells[classNow][specID][start + i]
			if not spellID then
				module.options.scrollFrame.C.spells[i]:Hide()
			else
				local frame = module.options.scrollFrame.C.spells[i]
				local spellName,_,spellTexture = GetSpellInfo(spellID)
				frame.icon:SetTexture(spellTexture)
				frame.link = GetSpellLink(spellID)
				frame.spellID = spellID
				frame.spellName:SetText(spellName)
				local isUnique = true
				for otherSpecID,otherSpecData in pairs(module.db.spells[classNow]) do
					if otherSpecID ~= specID then
						if ExRT.mds.table_find(otherSpecData,spellID) then
							isUnique = false
						end
					end
				end
				if isUnique then
					frame.spellName:SetTextColor(0.6,1,0.6,1)
				else
					frame.spellName:SetTextColor(1,1,1,1)
				end
				frame:Show()
			end
		end
	end
	
	local isSotred = {}
	local function sortSpells()
		for specID,specData in pairs(module.db.spells[classNow]) do
			local tmp = {}
			for _,spellID in pairs(specData) do
				local spellName = GetSpellInfo(spellID)
				if spellName then
					tmp[#tmp+1] = {spellID,spellName}
				else
					ExRT.mds.dprint('Spell '..spellID..' not found')
				end
			end
			table.sort(tmp,function(a,b) if(a[2]~=b[2]) then return a[2] < b[2] else return a[1] < b[1] end end)
			table.wipe(module.db.spells[classNow][specID])
			for i=1,#tmp do
				module.db.spells[classNow][specID][i]=tmp[i][1]
			end
		end
		isSotred[classNow] = true
	end
	
	local function specButtonClick(self)
		specNow = self._i
		for j=1,4 do
			if self._i==j then
				PanelTemplates_SelectTab(module.options.specsButtons[j])
			else
				PanelTemplates_DeselectTab(module.options.specsButtons[j])
			end
		end
		
		local specID = module.db.specByClass[classNow] and module.db.specByClass[classNow][self._i] or 0
		
		module.options.scrollFrame.ScrollBar:SetMinMaxValues(0,max((ceil(#module.db.spells[classNow][specID] / 3) - 20) * spellLineHeight,0))
		scrollFix = true
		module.options.scrollFrame.ScrollBar:SetValue(0)
		scrollFix = false
		scrollFrameValue = 0
		
		ReloadPage()
	end
	
	self.specsButtons = {}
	for i=1,4 do
		local frame = CreateFrame("Button", self:GetName().."SpecButton"..i, self, "OptionsFrameTabButtonTemplate")
		self.specsButtons[i] = frame
		frame:SetText(i)
		if i == 1 then
			frame:SetPoint("BOTTOMLEFT",self.scrollFrame,"TOPLEFT",0,5)
		else
			frame:SetPoint("LEFT", self.specsButtons[i-1], "RIGHT", -16, 0)
		end
		frame._i = i
		frame:SetScript("OnClick",specButtonClick)
		
		--/dump ExRTCSpellsOptionsSpecButton1
	end
	
	self.dropDown = CreateFrame("Frame", self:GetName().."DropDown", self, "UIDropDownMenuTemplate")
	self.dropDown:SetPoint("TOPLEFT",400,-5)
	self.dropDown:SetWidth(180)
	UIDropDownMenu_SetWidth(self.dropDown, 180)
	UIDropDownMenu_Initialize(self.dropDown, function(self, level, menuList)
		ExRT.mds.FixDropDown(180)
		local info = UIDropDownMenu_CreateInfo()
		for i, class in pairs(module.db.classNames) do
			info.text,info.notCheckable,info.minWidth,info.justifyH = ExRT.L.classLocalizate[class],1,180,"CENTER"
			info.menuList, info.hasArrow, info.arg1 = i, false, i
			info.func = self.SetValue
			info.colorCode = "|c"..ExRT.mds.classColor(class)
			UIDropDownMenu_AddButton(info)
		end
	end)

	function self.dropDown:SetValue(newValue)
		classNow = module.db.classNames[newValue]
		UIDropDownMenu_SetText(module.options.dropDown, "|c"..ExRT.mds.classColor(classNow)..ExRT.L.classLocalizate[classNow])
		CloseDropDownMenus()
		
		if not isSotred[classNow] then
			sortSpells()
		end
		
		local specs = module.db.specByClass[classNow] or {}
		for i=1,4 do
			if specs[i] then
				local frame = module.options.specsButtons[i]
				frame:Show()
				local icon = ""
				if module.db.specIcons[ specs[i] ] then
					icon = "|T".. module.db.specIcons[ specs[i] ] ..":20|t"
				end
				frame:SetText(icon..ExRT.L.specLocalizate[ module.db.specInLocalizate[ specs[i] ] ])
				frame:SetText(ExRT.L.specLocalizate[ module.db.specInLocalizate[ specs[i] ] ])
				frame:SetText(icon..ExRT.L.specLocalizate[ module.db.specInLocalizate[ specs[i] ] ])
				PanelTemplates_TabResize(frame, 0, nil, nil, frame:GetFontString():GetStringWidth(), frame:GetFontString():GetStringWidth())
			else
				module.options.specsButtons[i]:Hide()
			end
			if i == 1 then
				PanelTemplates_SelectTab(module.options.specsButtons[i])
			else
				PanelTemplates_DeselectTab(module.options.specsButtons[i])
			end
		end
		specNow = 1
		local specID = specs[1] or 0
		module.options.scrollFrame.ScrollBar:SetMinMaxValues(0,max((ceil(#module.db.spells[classNow][specID] / 3) - 20) * spellLineHeight,0))
		scrollFix = true
		module.options.scrollFrame.ScrollBar:SetValue(0)
		scrollFix = false
		scrollFrameValue = 0
		
		ReloadPage()
	end
	
	self.dropDown:SetValue(math.random(1,11))
end

function module.main:ADDON_LOADED()
end